/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.imply.cloud.manager.ClusterOperationResult;
import io.imply.cloud.manager.ClusterOperator;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.cluster.GetClusterStackCreationStatusNotice;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.onprem.model.OnPremCluster;
import io.imply.cloud.onprem.model.OnPremInfo;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.Logger;
import lombok.Generated;

public class OnPremKubernetesGetClusterStackCreationStatusNotice
extends GetClusterStackCreationStatusNotice
implements OnPremHelpers {
    @Generated
    private static final Logger log = Logger.from(OnPremKubernetesGetClusterStackCreationStatusNotice.class);
    private final ClusterDataManager clusterDataManager;
    private final ClusterOperator clusterOperator;

    @Inject
    public OnPremKubernetesGetClusterStackCreationStatusNotice(OnPremManagerToolbox toolbox, ClusterOperator clusterOperator) {
        super((ManagerToolbox)toolbox);
        this.clusterDataManager = toolbox.getClusterDataManager();
        this.clusterOperator = clusterOperator;
    }

    public void innerHandle() {
        String clusterId = this.info.getEntityId();
        State currentState = this.info.getState();
        String createOrUpdate = currentState.equals((Object)State.CREATING_CLUSTER_STACK) ? "create" : "update";
        String createdOrUpdated = currentState.equals((Object)State.CREATING_CLUSTER_STACK) ? "created" : "updated";
        String creatingOrUpdating = currentState.equals((Object)State.CREATING_CLUSTER_STACK) ? "creating" : "updating";
        OnPremCluster cluster = this.onprem(this.clusterDataManager.getOrNull(clusterId));
        if (cluster == null) {
            this.addCriticalNotification("Failed to %s cluster [%s]. Cluster not found", new Object[]{createOrUpdate, clusterId});
            log.error("Failed to %se cluster [%s]. Cluster not found", new Object[]{createOrUpdate, clusterId});
            this.entityStateDataManager.insert(this.info, Info.builder().withState(this.getFailureState()).build());
            return;
        }
        ClusterOperationResult clusterOperationResult = this.clusterOperator.getClusterOperationStatus((Cluster)cluster, currentState);
        switch (clusterOperationResult.getStatus()) {
            case FAILED: {
                this.addCriticalNotification("Failed to %s cluster [%s]. %s", new Object[]{createOrUpdate, clusterId, clusterOperationResult.getMessage()});
                log.error("Failed to %s cluster [%s]. %s", new Object[]{createOrUpdate, clusterId, clusterOperationResult.getMessage()});
                this.entityStateDataManager.insert(this.info, Info.builder().withState(this.getFailureState()).build());
                break;
            }
            case PENDING: {
                this.addInfoNotification("%s cluster [%s]. %s", new Object[]{creatingOrUpdating, clusterId, clusterOperationResult.getMessage()});
                break;
            }
            case COMPLETE: {
                this.addInfoNotification("Successfully %s cluster [%s].", new Object[]{createdOrUpdated, clusterId});
                if (currentState.equals((Object)State.CREATING_CLUSTER_STACK)) {
                    this.entityStateDataManager.insert(this.info, Info.builder().withState(State.PLAN_CLUSTER_CREATION).build());
                } else {
                    this.entityStateDataManager.insert(this.info, (Info)((OnPremInfo.Builder)((OnPremInfo.Builder)OnPremInfo.builder().withState(State.PLAN_CLUSTER_UPDATE)).withUpdateState(UpdateState.builder((UpdateState)this.info.getUpdateState()).currentState(State.PLAN_CLUSTER_UPDATE).build())).build());
                }
                this.setQueueNextNotice();
            }
        }
    }

    protected State getTimeoutState() {
        return this.getFailureState();
    }

    protected Status getFailureStatus() {
        if (State.CLUSTER_UPDATED.equals((Object)this.info.getDesiredState())) {
            return Status.WARNING;
        }
        return Status.CRITICAL;
    }

    @VisibleForTesting
    State getFailureState() {
        if (State.CLUSTER_UPDATED.equals((Object)this.info.getDesiredState())) {
            return State.CLUSTER_UPDATE_FAILED_PROMPT_USER;
        }
        return State.CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION;
    }
}

