/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import com.google.inject.Inject;
import io.imply.cloud.manager.ClusterOperationResult;
import io.imply.cloud.manager.ClusterOperator;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.cluster.DeleteClusterStackNotice;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.onprem.model.OnPremCluster;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.Logger;
import lombok.Generated;

public class OnPremKubernetesDeleteClusterStackNotice
extends DeleteClusterStackNotice
implements OnPremHelpers {
    @Generated
    private static final Logger log = Logger.from(OnPremKubernetesDeleteClusterStackNotice.class);
    protected final ClusterDataManager clusterDataManager;
    private final ClusterOperator clusterOperator;

    @Inject
    public OnPremKubernetesDeleteClusterStackNotice(OnPremManagerToolbox toolbox, ClusterOperator clusterOperator) {
        super((ManagerToolbox)toolbox);
        this.clusterDataManager = toolbox.getClusterDataManager();
        this.clusterOperator = clusterOperator;
    }

    public void innerHandle() {
        OnPremCluster cluster = this.onprem(this.clusterDataManager.get(this.info.getEntityId()));
        ClusterOperationResult clusterOperationResult = this.deleteCluster(cluster);
        if (ClusterOperationResult.Status.FAILED.equals((Object)clusterOperationResult.getStatus())) {
            log.warn("Failed to delete cluster [%s]. %s", new Object[]{cluster.getClusterId(), clusterOperationResult.getMessage()});
            this.addCriticalNotification("Failed to delete cluster. %s", new Object[]{clusterOperationResult.getMessage()});
            this.entityStateDataManager.insert(this.info, Info.builder().withState(this.getExceptionState()).build());
        } else {
            this.entityStateDataManager.insert(this.info, Info.builder().withState(State.DELETING_CLUSTER_STACK).build());
        }
        this.setQueueNextNotice();
    }

    protected ClusterOperationResult deleteCluster(Cluster cluster) {
        log.info("Submitting request to delete cluster stack");
        this.addInfoNotification("Submitting request to delete cluster stack", new Object[0]);
        return this.clusterOperator.deleteCluster(cluster);
    }

    protected State getTimeoutState() {
        return this.getExceptionState();
    }

    protected Status getFailureStatus() {
        return Status.WARNING;
    }

    protected State getExceptionState() {
        return State.CLUSTER_DELETE_FAILED;
    }
}

