/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import com.google.inject.Inject;
import io.imply.cloud.manager.ClusterOperator;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.cluster.DeleteClusterStackAndSetFailureNotice;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.Logger;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;

public class OnPremKubernetesDeleteClusterStackAndSetFailureNotice
extends DeleteClusterStackAndSetFailureNotice
implements OnPremHelpers {
    @Generated
    private static final Logger log = Logger.from(OnPremKubernetesDeleteClusterStackAndSetFailureNotice.class);
    private final ClusterDataManager clusterDataManager;
    private final ClusterOperator clusterOperator;

    @Inject
    public OnPremKubernetesDeleteClusterStackAndSetFailureNotice(OnPremManagerToolbox toolbox, ClusterOperator clusterOperator) {
        super((ManagerToolbox)toolbox);
        this.clusterDataManager = toolbox.getClusterDataManager();
        this.clusterOperator = clusterOperator;
    }

    public void innerHandle() {
        Cluster cluster = this.clusterDataManager.get(this.info.getEntityId());
        if (BooleanUtils.isNotTrue((Boolean)this.toolbox.getManagerConfig().isRetainFailedClusters())) {
            this.addInfoNotification("Submitting request to  delete cluster stack", new Object[0]);
            this.clusterOperator.deleteCluster(cluster);
        }
        log.warn("Cluster [%s] failed with state [%s]", new Object[]{this.info.getEntityId(), this.getExceptionState()});
        this.entityStateDataManager.insert(this.info, Info.builder().withState(this.getExceptionState()).build());
    }
}

