/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.imply.cloud.Toolbox;
import io.imply.cloud.druid.DruidApiClient;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.cluster.CancelClusterAgentsUpdateNotice;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.User;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.util.ClusterNodesHelper;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Retryable;
import io.imply.cloud.util.ThreadLocalContext;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class OnPremCancelClusterAgentsUpdateNotice
extends CancelClusterAgentsUpdateNotice
implements OnPremHelpers {
    private static final Logger log = new Logger(OnPremCancelClusterAgentsUpdateNotice.class);
    private final OnPremManagerToolbox toolbox;

    @Inject
    public OnPremCancelClusterAgentsUpdateNotice(ManagerToolbox toolbox) {
        super(toolbox);
        this.toolbox = this.onprem((Toolbox)toolbox);
    }

    public void innerHandle() {
        ClusterNodes clusterNodes = this.toolbox.getClusterNodesDataManager().getVersionOrNull(this.info.getEntityId(), this.info.getDeployedClusterNodesVersion().intValue());
        if (clusterNodes == null) {
            throw new ISE("Could not get nodes [%s] for cluster [%s], cannot continue.", new Object[]{this.info.getDeployedClusterNodesVersion(), this.info.getEntityId()});
        }
        ImmutableSet dataHosts = ImmutableSet.copyOf((Collection)ClusterNodesHelper.getSortedDataHosts((Map)clusterNodes.getNodes()));
        ImmutableSet masterHosts = ImmutableSet.copyOf((Collection)ClusterNodesHelper.getSortedMasterHosts((Map)clusterNodes.getNodes()));
        dataHosts.forEach(host -> Retryable.of(() -> {
            log.info("Enabling middle manager [%s]", new Object[]{host});
            this.toolbox.getDruidApiClient().enableMiddleManager(host, this.info.getEntityId());
        }, (int)3, (int)1, e -> log.warn((Throwable)e, "Failed to enable middle manager [%s] in cluster [%s]", new Object[]{host, this.info.getEntityId()}), (boolean)true));
        if (this.info.getUpdateState() != null && this.info.getUpdateState().getCoordinatorDynamicConfiguration() != null) {
            User principal = ThreadLocalContext.getPrincipal();
            Retryable.of(() -> this.lambda$innerHandle$3((Set)masterHosts, principal), (int)3, (int)1, e -> log.warn((Throwable)e, "Failed to reset coordinator dynamic configuration"), (boolean)true);
        }
        this.entityStateDataManager.insert(this.info, Info.builder().withState(State.CLUSTER_UPDATE_ROLLED_BACK).clearExistingUpdateState().build());
        this.addInfoNotification("Update cancelled", new Object[0]);
        this.markNotificationsAsPrevious();
    }

    private /* synthetic */ void lambda$innerHandle$3(Set masterHosts, User principal) {
        log.info("Restoring [maxSegmentsToMove] and [replicationThrottleLimit] to original values after rolling update");
        this.toolbox.getDruidApiClient().setCoordinatorDynamicConfiguration((Collection)masterHosts, this.info.getUpdateState().getCoordinatorDynamicConfiguration(), this.info.getEntityId(), DruidApiClient.generateAuditAuthor((String)(principal == null ? null : principal.getDetailedUserId())), "Restoring [maxSegmentsToMove] and [replicationThrottleLimit] to original values after rolling update");
    }
}

