/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.manager;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.imply.cloud.guice.annotations.ManageLifecycleLast;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Notification;
import io.imply.cloud.model.State;
import io.imply.cloud.persistence.NotificationDataManager;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;

@ManageLifecycleLast
public class OnPremSecurityManager {
    @VisibleForTesting
    static final String SECURITY_CHANGED_NOTIFICATION_MESSAGE = "Security settings have changed. Restart cluster to update.";
    private final ManagerToolbox toolbox;

    @Inject
    public OnPremSecurityManager(ManagerToolbox toolbox) {
        this.toolbox = toolbox;
    }

    @LifecycleStart
    public void start() {
        List clusters = this.toolbox.getClusterDataManager().getAll();
        for (Cluster cluster : clusters) {
            String key = String.format("%s/%s", cluster.getAccountId(), cluster.getClusterId());
            if (this.isModified(cluster)) {
                Info info = this.toolbox.getEntityStateDataManager().get(cluster);
                if (State.UPDATING.equals((Object)info.getState().getExternalState(State.CLUSTER_UPDATED))) {
                    this.toolbox.getEntityStateDataManager().insert(cluster, Info.builder().withState(State.CLUSTER_UPDATE_FAILED_PROMPT_USER).build());
                }
                this.toolbox.getNotificationDataManager().insert(Notification.of((String)SECURITY_CHANGED_NOTIFICATION_MESSAGE, null, (Notification.Level)Notification.Level.WARNING, (String)key));
                continue;
            }
            this.toolbox.getNotificationDataManager().getAllWithEntityKey(key).getNotificationList().stream().filter(x -> SECURITY_CHANGED_NOTIFICATION_MESSAGE.equals(x.getMessage())).forEach(arg_0 -> ((NotificationDataManager)this.toolbox.getNotificationDataManager()).delete(arg_0));
        }
    }

    private boolean isModified(Cluster cluster) {
        boolean useTls = BooleanUtils.isTrue((Boolean)cluster.isUseTls());
        boolean useAuthentication = BooleanUtils.isTrue((Boolean)cluster.isUseAuthentication());
        return this.toolbox.getApplicationConfig().useTls() != useTls || this.toolbox.getApplicationConfig().useAuthentication() != useAuthentication || !this.toolbox.getSecurityConfig().hasSameCertificates(cluster.getSecurityConfiguration());
    }
}

