/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.manager;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.imply.cloud.Constants;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.ConfigServerConfig;
import io.imply.cloud.config.CreationAgentConfig;
import io.imply.cloud.config.DefaultsConfig;
import io.imply.cloud.model.DefaultsAndSupportedValues;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.UserFile;
import io.imply.cloud.model.druid.DeepStorage;
import io.imply.cloud.model.metadatastorage.MetadataStorage;
import io.imply.cloud.model.zookeeper.ExternalZooKeeper;
import io.imply.cloud.model.zookeeper.ZooKeeper;
import io.imply.cloud.onprem.manager.OnPremInfoRouteManager;
import io.imply.cloud.onprem.model.OnPremCluster;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.ImplyVersionHelper;
import io.imply.cloud.util.InstanceTypeHelper;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class OnPremKubernetesInfoRouteManager
extends OnPremInfoRouteManager {
    @Inject
    public OnPremKubernetesInfoRouteManager(ClusterDataManager clusterDataManager, CreationAgentConfig creationAgentConfig, DefaultsConfig defaultsConfig, ApplicationConfig applicationConfig, ObjectMapper objectMapper, ConfigServerConfig configServerConfig, ImplyVersionHelper implyVersionHelper, AccountDataManager accountDataManager, RefreshableConstants refreshableConstants, InstanceTypeHelper instanceTypeHelper) {
        super(clusterDataManager, creationAgentConfig, defaultsConfig, applicationConfig, objectMapper, configServerConfig, implyVersionHelper, accountDataManager, refreshableConstants, instanceTypeHelper);
    }

    @Override
    protected OnPremCluster getDefaultCluster(String clusterId, ImplyVersion implyVersion, MetadataStorage metadataStorage, ZooKeeper zk, DeepStorage deepStorage, List<String> featureFlags, Map<String, String> userExtensions, List<UserFile> customFiles) {
        zk = new ExternalZooKeeper(String.format("%s-zookeeper", HelmUtils.generateReleaseNameForCluster(((OnPremCluster.Builder)OnPremCluster.builder().withClusterId(clusterId)).build(), this.applicationConfig)), "/druid");
        return ((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)OnPremCluster.builder().withClusterId(clusterId)).withImplyVersion(implyVersion.getVersion())).withImplyVersionFull(implyVersion)).withMasterInstanceType(this.instanceTypeHelper.getDefaultInstanceTypeForNodeType(ImplyNodeType.MASTER))).withQueryInstanceType(this.instanceTypeHelper.getDefaultInstanceTypeForNodeType(ImplyNodeType.QUERY))).withMasterInstanceCount(3)).withQueryInstanceCount(1)).withDataInstanceTiers((Map)ImmutableMap.of((Object)1, (Object)new InstanceTier("_default_tier", this.instanceTypeHelper.getDefaultInstanceTypeForNodeType(ImplyNodeType.DATA), Integer.valueOf(1), Constants.DRUID_SERVER_TIER_PRIORITY_DEFAULT)))).withMetadataStorage(metadataStorage)).withZooKeeper(zk)).withDeepStorage(deepStorage)).withFeatureFlags(featureFlags)).withUserExtensions(userExtensions)).withCustomFiles(customFiles)).withDefaultsForUnset(this.applicationConfig, true, this.instanceTypeHelper).withSensitiveFieldsMasked()).build();
    }

    @Override
    public DefaultsAndSupportedValues getDefaultsAndSupportedValues(String accountId) {
        String clusterId = UUID.randomUUID().toString();
        return new DefaultsAndSupportedValues(this.getDefaultClusterSpec(clusterId, String.format("druid_%s", clusterId.substring(0, 8))), this.refreshableConstants.getSupportedMasterInstanceTypes(), this.refreshableConstants.getSupportedQueryInstanceTypes(), this.refreshableConstants.getSupportedDataInstanceTypes(), null, this.implyVersionHelper.getSupportedImplyVersionsIncludingAccountVersions(accountId, this.clusterDataManager), this.refreshableConstants.getDruidExtensions(), Constants.SUPPORTED_TARBALL_EXTENSIONS, null);
    }
}

