/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.manager;

import com.google.common.collect.ImmutableMap;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Pair;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import lombok.Generated;

@Path(value="/kubernetes/v1/{clusterId}")
public class KubernetesResource {
    protected final ManagerToolbox toolbox;
    protected final K8sUtilsProvider k8sUtilsProvider;

    @GET
    @Path(value="safeToTerminate/{podName}")
    @Produces(value={"application/json"})
    public Response safeToTerminatePod(@PathParam(value="clusterId") String clusterId, @PathParam(value="podName") String podName) {
        Cluster cluster = this.toolbox.getClusterDataManager().get(clusterId);
        if (!this.isClusterRunning(cluster) || this.isClusterHardUpdating(cluster)) {
            return Response.ok().entity((Object)ImmutableMap.of((Object)"safeToTerminate", (Object)true)).build();
        }
        String releaseName = HelmUtils.generateReleaseNameForCluster(cluster, this.toolbox.getApplicationConfig());
        String releaseNamespace = HelmUtils.generateNamespaceForCluster(cluster, this.toolbox.getApplicationConfig());
        String statefulSetName = (String)this.getStatefulsetNameOrdinalIndexPair((String)podName).lhs;
        if (!this.isTierDeployed(cluster, statefulSetName)) {
            return Response.ok().entity((Object)ImmutableMap.of((Object)"safeToTerminate", (Object)true)).build();
        }
        List<Pod> pods = this.getStatefulsetPods(clusterId, statefulSetName, releaseName, releaseNamespace);
        if (!pods.stream().anyMatch(p -> p.getMetadata().getName().equals(podName))) {
            throw new ISE("could not find requester pod %s", new Object[]{podName});
        }
        Optional<String> leaderPod = this.getLeaderPod(pods, statefulSetName);
        if (!leaderPod.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)String.format("Pod %s is not in a terminating state, restart could be due to a livenessProbe failure", podName))).build();
        }
        return Response.ok().entity((Object)ImmutableMap.of((Object)"safeToTerminate", (Object)podName.equals(leaderPod.get()), (Object)"leader", (Object)((Serializable)((Object)leaderPod.get())))).build();
    }

    protected Pair<String, Integer> getStatefulsetNameOrdinalIndexPair(String podName) {
        Pattern pattern = Pattern.compile("(.*)-(\\d+)$");
        Matcher matcher = pattern.matcher(podName);
        if (!matcher.find()) {
            throw new IAE("podname %s did not match statefulset naming regex", new Object[]{podName});
        }
        String statefulSetName = matcher.group(1);
        Integer ordinalIndex = Integer.parseInt(matcher.group(2));
        return Pair.of((Object)statefulSetName, (Object)ordinalIndex);
    }

    private boolean isClusterRunning(Cluster cluster) {
        Info info = this.toolbox.getEntityStateDataManager().get(cluster);
        return info.getState().isRunning();
    }

    private boolean isClusterHardUpdating(Cluster cluster) {
        Info info = this.toolbox.getEntityStateDataManager().get(cluster);
        return UpdateType.HARD.equals((Object)info.getUpdateType());
    }

    protected List<Pod> getStatefulsetPods(String clusterId, String statefulSetName, String releaseName, String releaseNamespace) {
        try {
            return this.k8sUtilsProvider.getKubernetesUtilsFromCluster(clusterId).getPodsOfStatefulSet(statefulSetName, releaseNamespace);
        }
        catch (KubernetesClientException e) {
            throw new ISE((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    protected Optional<String> getLeaderPod(List<Pod> pods, String statefulSetName) {
        return pods.stream().filter(p -> p.getMetadata().getDeletionTimestamp() != null).map(p -> this.getStatefulsetNameOrdinalIndexPair(p.getMetadata().getName())).max(Comparator.comparing(p -> (Integer)p.rhs)).map(p -> String.format("%s-%d", p.lhs, p.rhs));
    }

    protected boolean isTierDeployed(Cluster cluster, String statefulsetName) {
        return true;
    }

    @Inject
    @Generated
    public KubernetesResource(ManagerToolbox toolbox, K8sUtilsProvider k8sUtilsProvider) {
        this.toolbox = toolbox;
        this.k8sUtilsProvider = k8sUtilsProvider;
    }
}

