/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.manager;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigBuilder;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElector;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaseLock;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;
import io.imply.cloud.concurrent.Execs;
import io.imply.cloud.server.kubernetes.KubernetesLeaderConfig;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import java.io.Closeable;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.Generated;

public class KubernetesLeaderElectorWrapper
implements Closeable {
    @Generated
    private static final Logger log = Logger.from(KubernetesLeaderElectorWrapper.class);
    private ExecutorService executor;
    private final AtomicReference<Future<?>> futureRef = new AtomicReference();
    private final KubernetesClient kubernetesClient = new KubernetesClientBuilder().build();
    private final LeaderElector leaderElector;
    private final Lock leaseLock;

    public KubernetesLeaderElectorWrapper(String managerId, KubernetesLeaderConfig kubernetesLeaderConfig, Runnable startLeadingHook, Runnable stopLeadingHook, Consumer<String> onLeaderChange) {
        this.leaseLock = new LeaseLock(kubernetesLeaderConfig.getNamespace(), kubernetesLeaderConfig.getLeaseName(), managerId);
        LeaderElectionConfig leaderElectionConfig = ((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)new LeaderElectionConfigBuilder().withName("Manager Leader Elector")).withLeaseDuration(Duration.ofMillis(kubernetesLeaderConfig.getLeaseDurationMs()))).withLock(this.leaseLock)).withRenewDeadline(Duration.ofMillis(kubernetesLeaderConfig.getRenewDeadlineMs()))).withRetryPeriod(Duration.ofMillis(kubernetesLeaderConfig.getRetryPeriodMs()))).withLeaderCallbacks(new LeaderCallbacks(startLeadingHook, stopLeadingHook, onLeaderChange))).build();
        this.leaderElector = this.kubernetesClient.leaderElector().withConfig(leaderElectionConfig).build();
    }

    public void run() {
        this.executor = Execs.singleThreaded((String)this.getClass().getSimpleName());
        this.futureRef.set(this.executor.submit(() -> ((LeaderElector)this.leaderElector).run()));
    }

    @Override
    public void close() {
        try {
            this.futureRef.get().cancel(true);
            this.kubernetesClient.close();
            this.executor.shutdownNow();
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                log.warn("Failed to terminate [%s] executor.", new Object[]{this.getClass().getSimpleName()});
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public String getCurrentLeader() {
        try {
            return Optional.ofNullable(this.leaseLock.get(this.kubernetesClient).getHolderIdentity()).orElseThrow(() -> new ISE("Manager leader not found", new Object[0]));
        }
        catch (KubernetesClientException e) {
            throw new RuntimeException("failed to get current leader", e);
        }
    }
}

