/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.guice;

import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.configurator.resources.AuthenticationResource;
import io.imply.cloud.configurator.resources.ConfiguratorResource;
import io.imply.cloud.guice.ApplicationModule;
import io.imply.cloud.guice.JsonConfigProvider;
import io.imply.cloud.guice.LifecycleModule;
import io.imply.cloud.guice.annotations.LazySingleton;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.NetworkStackHelper;
import io.imply.cloud.manager.NodeHelper;
import io.imply.cloud.manager.notice.account.UpdateAccountNotice;
import io.imply.cloud.manager.notice.cluster.CancelClusterAgentsUpdateNotice;
import io.imply.cloud.manager.notice.cluster.ExecuteStagedOperationNotice;
import io.imply.cloud.manager.notice.cluster.HandleRetryUpdateRequestNotice;
import io.imply.cloud.manager.notice.cluster.HandleRollbackUpdateRequestNotice;
import io.imply.cloud.manager.notice.cluster.PlanAgentUpdateNotice;
import io.imply.cloud.manager.notice.cluster.PostCreateNotice;
import io.imply.cloud.manager.notice.cluster.PostDeleteNotice;
import io.imply.cloud.manager.notice.cluster.PostStartNotice;
import io.imply.cloud.manager.notice.cluster.PostStopNotice;
import io.imply.cloud.manager.notice.cluster.PreCreateNotice;
import io.imply.cloud.manager.notice.cluster.PreDeleteNotice;
import io.imply.cloud.manager.notice.cluster.PreStartNotice;
import io.imply.cloud.manager.notice.cluster.PreStopNotice;
import io.imply.cloud.manager.notice.cluster.ReloadNodeNotice;
import io.imply.cloud.manager.notice.cluster.RevertClusterRequestClusterStackRollbackNotice;
import io.imply.cloud.manager.notice.cluster.RevertClusterSetUpdateFailedNotice;
import io.imply.cloud.manager.notice.cluster.RevertClusterSetUpdateRolledBackNotice;
import io.imply.cloud.manager.notice.cluster.SetClusterCreationFailedNotice;
import io.imply.cloud.manager.notice.cluster.SetClusterRolledBackOrRevertRollingUpdateNotice;
import io.imply.cloud.manager.notice.cluster.SetClusterStartFailedNotice;
import io.imply.cloud.manager.notice.operations.CheckGroveAgentsNotice;
import io.imply.cloud.manager.notice.operations.CheckInstanceHealthNotice;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.metadatastorage.MySqlMetadataStorage;
import io.imply.cloud.model.metadatastorage.PostgreSqlMetadataStorage;
import io.imply.cloud.onprem.config.OnPremAccountConfigurator;
import io.imply.cloud.onprem.config.OnPremClusterConfigurator;
import io.imply.cloud.onprem.config.OnPremManagerConfig;
import io.imply.cloud.onprem.configurator.OnPremClusterAuthConfiguratorModule;
import io.imply.cloud.onprem.guice.OnPrem;
import io.imply.cloud.onprem.guice.OnPremKubernetesModule;
import io.imply.cloud.onprem.guice.OnPremStandardModule;
import io.imply.cloud.onprem.guice.OperatorModule;
import io.imply.cloud.onprem.jackson.OnPremAccountMixIn;
import io.imply.cloud.onprem.jackson.OnPremClusterMixIn;
import io.imply.cloud.onprem.jackson.OnPremInfoMixIn;
import io.imply.cloud.onprem.manager.DruidResource;
import io.imply.cloud.onprem.manager.OnPremSecurityManager;
import io.imply.cloud.onprem.model.OnPremAccount;
import io.imply.cloud.onprem.model.OnPremCluster;
import io.imply.cloud.onprem.model.OnPremInfo;
import io.imply.cloud.onprem.notice.cluster.OnPremCancelClusterAgentsUpdateNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremExecuteStagedOperationNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremHandleRetryUpdateRequestNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremHandleRollbackUpdateRequestNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremPlanAgentUpdateNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremPostCreateNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremPostDeleteNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremPostStartNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremPostStopNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremPreCreateNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremPreDeleteNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremPreStartNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremPreStopNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremReloadNodeNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremRevertClusterRequestClusterStackRollbackNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremRevertClusterSetUpdateFailedNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremRevertClusterSetUpdateRolledBackNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremSetClusterCreationFailedNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremSetClusterRolledBackOrRevertRollingUpdateNotice;
import io.imply.cloud.onprem.notice.cluster.OnPremSetClusterStartFailedNotice;
import io.imply.cloud.onprem.notice.operations.OnPremCheckGroveAgentsNotice;
import io.imply.cloud.onprem.notice.operations.OnPremCheckInstanceHealthNotice;
import io.imply.cloud.onprem.stage.OnPremApplyHelmStage;
import io.imply.cloud.onprem.stage.OnPremApplyKubernetesManifestsStage;
import io.imply.cloud.onprem.stage.OnPremAwaitAgentReplacementStage;
import io.imply.cloud.onprem.stage.OnPremAwaitDataInstancesAvailableStage;
import io.imply.cloud.onprem.stage.OnPremAwaitHelmStage;
import io.imply.cloud.onprem.stage.OnPremAwaitKubernetesDeploymentUpdatedStage;
import io.imply.cloud.onprem.stage.OnPremAwaitMasterInstancesAvailableStage;
import io.imply.cloud.onprem.stage.OnPremAwaitPodsDeletedStage;
import io.imply.cloud.onprem.stage.OnPremAwaitPodsReadyStage;
import io.imply.cloud.onprem.stage.OnPremAwaitQueryInstancesAvailableStage;
import io.imply.cloud.onprem.stage.OnPremCleanupDataTiersStage;
import io.imply.cloud.onprem.stage.OnPremDeleteKubernetesManifestsStage;
import io.imply.cloud.onprem.stage.OnPremKubernetesAwaitPodTerminationStage;
import io.imply.cloud.onprem.stage.OnPremKubernetesEvictPodStage;
import io.imply.cloud.onprem.stage.creation.OnPremBecomeServicesStage;
import io.imply.cloud.onprem.stage.creation.OnPremCheckZooKeeperStage;
import io.imply.cloud.onprem.stage.creation.OnPremFetchConfigBundleStage;
import io.imply.cloud.onprem.stage.creation.OnPremMaybeCreateMetadataDatabaseStage;
import io.imply.cloud.onprem.stage.creation.OnPremStopServicesStage;
import io.imply.cloud.onprem.stage.creation.OnPremWriteConfigServerRequestPayloadStage;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.onprem.util.OnPremNetworkStackHelper;
import io.imply.cloud.onprem.util.OnPremNodeHelper;
import io.imply.cloud.server.jetty.JettyServerInitializer;
import io.imply.cloud.server.jetty.JettyServerInitializerImpl;
import io.imply.cloud.util.ISE;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

public class OnPremModule
implements ApplicationModule {
    @Inject
    ApplicationConfig applicationConfig;

    public List<? extends com.fasterxml.jackson.databind.Module> getJacksonModules() {
        if (!this.applicationConfig.isOnPrem()) {
            return Collections.emptyList();
        }
        SimpleModule module = new SimpleModule(this.getClass().getSimpleName());
        module.registerSubtypes(new NamedType[]{new NamedType(OnPremAccount.class, "onprem"), new NamedType(OnPremCluster.class, "onprem"), new NamedType(OnPremInfo.class, "onprem"), new NamedType(MySqlMetadataStorage.class, "mysql"), new NamedType(PostgreSqlMetadataStorage.class, "postgresql")});
        module.setMixInAnnotation(Account.class, OnPremAccountMixIn.class).setMixInAnnotation(Cluster.class, OnPremClusterMixIn.class).setMixInAnnotation(Info.class, OnPremInfoMixIn.class);
        if (this.applicationConfig.isManager()) {
            module.registerSubtypes(new NamedType[]{new NamedType(OnPremAwaitDataInstancesAvailableStage.class), new NamedType(OnPremAwaitQueryInstancesAvailableStage.class), new NamedType(OnPremAwaitMasterInstancesAvailableStage.class), new NamedType(OnPremAwaitAgentReplacementStage.class), new NamedType(OnPremKubernetesEvictPodStage.class), new NamedType(OnPremKubernetesAwaitPodTerminationStage.class), new NamedType(OnPremWriteConfigServerRequestPayloadStage.class), new NamedType(OnPremFetchConfigBundleStage.class), new NamedType(OnPremBecomeServicesStage.class), new NamedType(OnPremStopServicesStage.class), new NamedType(OnPremMaybeCreateMetadataDatabaseStage.class), new NamedType(OnPremCheckZooKeeperStage.class), new NamedType(OnPremApplyKubernetesManifestsStage.class), new NamedType(OnPremDeleteKubernetesManifestsStage.class), new NamedType(OnPremAwaitKubernetesDeploymentUpdatedStage.class), new NamedType(OnPremAwaitPodsReadyStage.class), new NamedType(OnPremAwaitPodsDeletedStage.class), new NamedType(OnPremApplyHelmStage.class), new NamedType(OnPremAwaitHelmStage.class), new NamedType(OnPremCleanupDataTiersStage.class)});
        }
        return ImmutableList.of((Object)module);
    }

    public List<? extends Module> getModuleOverrides() {
        if (!this.applicationConfig.isOnPrem()) {
            return Collections.emptyList();
        }
        return ImmutableList.of((Object)((Object)new OnPremClusterAuthConfiguratorModule()));
    }

    public void configure(Binder binder) {
        if (!this.applicationConfig.isOnPrem()) {
            return;
        }
        JsonConfigProvider.bind((Binder)binder, (String)"manager.onprem", OnPremManagerConfig.class);
        binder.bind(JettyServerInitializer.class).to(JettyServerInitializerImpl.class);
        if (this.applicationConfig.isManager()) {
            if (this.applicationConfig.isKubernetesMode()) {
                binder.install((Module)new OnPremKubernetesModule());
            } else {
                binder.install((Module)new OnPremStandardModule());
            }
            binder.bind(ManagerToolbox.class).to(OnPremManagerToolbox.class).in(LazySingleton.class);
            binder.bind(ConfiguratorResource.class).asEagerSingleton();
            binder.bind(DruidResource.class).asEagerSingleton();
            binder.bind(AuthenticationResource.class).asEagerSingleton();
            binder.bind(PostDeleteNotice.class).annotatedWith(OnPrem.class).to(OnPremPostDeleteNotice.class);
            binder.bind(PostStartNotice.class).annotatedWith(OnPrem.class).to(OnPremPostStartNotice.class);
            binder.bind(ExecuteStagedOperationNotice.class).annotatedWith(OnPrem.class).to(OnPremExecuteStagedOperationNotice.class);
            binder.bind(HandleRetryUpdateRequestNotice.class).annotatedWith(OnPrem.class).to(OnPremHandleRetryUpdateRequestNotice.class);
            binder.bind(HandleRollbackUpdateRequestNotice.class).annotatedWith(OnPrem.class).to(OnPremHandleRollbackUpdateRequestNotice.class);
            binder.bind(RevertClusterRequestClusterStackRollbackNotice.class).annotatedWith(OnPrem.class).to(OnPremRevertClusterRequestClusterStackRollbackNotice.class);
            binder.bind(RevertClusterSetUpdateFailedNotice.class).annotatedWith(OnPrem.class).to(OnPremRevertClusterSetUpdateFailedNotice.class);
            binder.bind(RevertClusterSetUpdateRolledBackNotice.class).annotatedWith(OnPrem.class).to(OnPremRevertClusterSetUpdateRolledBackNotice.class);
            binder.bind(PostCreateNotice.class).annotatedWith(OnPrem.class).to(OnPremPostCreateNotice.class);
            binder.bind(SetClusterCreationFailedNotice.class).annotatedWith(OnPrem.class).to(OnPremSetClusterCreationFailedNotice.class);
            binder.bind(SetClusterRolledBackOrRevertRollingUpdateNotice.class).annotatedWith(OnPrem.class).to(OnPremSetClusterRolledBackOrRevertRollingUpdateNotice.class);
            binder.bind(SetClusterStartFailedNotice.class).annotatedWith(OnPrem.class).to(OnPremSetClusterStartFailedNotice.class);
            binder.bind(PostStopNotice.class).annotatedWith(OnPrem.class).to(OnPremPostStopNotice.class);
            binder.bind(PreStartNotice.class).annotatedWith(OnPrem.class).to(OnPremPreStartNotice.class);
            binder.bind(PreStopNotice.class).annotatedWith(OnPrem.class).to(OnPremPreStopNotice.class);
            binder.bind(PreCreateNotice.class).annotatedWith(OnPrem.class).to(OnPremPreCreateNotice.class);
            binder.bind(ReloadNodeNotice.class).annotatedWith(OnPrem.class).to(OnPremReloadNodeNotice.class);
            binder.bind(PlanAgentUpdateNotice.class).annotatedWith(OnPrem.class).to(OnPremPlanAgentUpdateNotice.class);
            binder.bind(UpdateAccountNotice.class).annotatedWith(OnPrem.class).to(UpdateAccountNotice.class);
            binder.bind(CancelClusterAgentsUpdateNotice.class).annotatedWith(OnPrem.class).to(OnPremCancelClusterAgentsUpdateNotice.class);
            binder.bind(PreDeleteNotice.class).annotatedWith(OnPrem.class).to(OnPremPreDeleteNotice.class);
            binder.bind(CheckGroveAgentsNotice.class).to(OnPremCheckGroveAgentsNotice.class);
            binder.bind(CheckInstanceHealthNotice.class).to(OnPremCheckInstanceHealthNotice.class);
            binder.bind(NetworkStackHelper.class).to(OnPremNetworkStackHelper.class).in(LazySingleton.class);
            binder.bind(NodeHelper.class).to(OnPremNodeHelper.class).in(LazySingleton.class);
            LifecycleModule.register((Binder)binder, OnPremAccountConfigurator.class);
            LifecycleModule.register((Binder)binder, OnPremClusterConfigurator.class);
            LifecycleModule.register((Binder)binder, OnPremSecurityManager.class);
        }
    }

    @VisibleForTesting
    void maybeAddOperatorModuleExtension(Binder binder) {
        ServiceLoader<OperatorModule> operatorModuleServiceLoader = ServiceLoader.load(OperatorModule.class, Thread.currentThread().getContextClassLoader());
        if (!operatorModuleServiceLoader.iterator().hasNext()) {
            throw new ISE("Unable to find an OperatorModule implementation. Check whether classpath has the correct JARs installed.", new Object[0]);
        }
        try {
            OperatorModule module = operatorModuleServiceLoader.iterator().next();
            binder.install((Module)module);
        }
        catch (Exception e) {
            throw new ISE("Unable to install OperatorModule", new Object[]{e});
        }
    }
}

