/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.imply.cloud.Constants;
import io.imply.cloud.grove.Node;
import io.imply.cloud.guice.annotations.ManageLifecycleLast;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.operations.OperationsNotice;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterWithExtendedInfo;
import io.imply.cloud.model.DefaultsUpdateType;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Notification;
import io.imply.cloud.model.State;
import io.imply.cloud.model.UpdateDetails;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.onprem.manager.OnPremInfoRouteManager;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ThreadUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.joda.time.Period;

@ManageLifecycleLast
public class OnPremClusterConfigurator {
    @Generated
    private static final Logger log = Logger.from(OnPremClusterConfigurator.class);
    private final ManagerToolbox toolbox;
    private final OnPremInfoRouteManager infoRouteManager;
    private final ThreadUtils threadUtils;

    @LifecycleStart
    public void start() {
        Period updateDelay = this.toolbox.getManagerConfig().getUpdateDelay();
        if (updateDelay != null) {
            log.info("Delaying update for [%s] according to updateDelay", new Object[]{updateDelay});
            this.threadUtils.setTimeout(this::queueNotice, updateDelay.toStandardDuration().getMillis(), TimeUnit.MILLISECONDS);
        } else {
            this.queueNotice();
        }
    }

    @VisibleForTesting
    void queueNotice() {
        this.toolbox.getNoticeManager().queueNotice((io.imply.cloud.manager.notice.Notice)new Notice(), false);
    }

    @Inject
    @Generated
    public OnPremClusterConfigurator(ManagerToolbox toolbox, OnPremInfoRouteManager infoRouteManager, ThreadUtils threadUtils) {
        this.toolbox = toolbox;
        this.infoRouteManager = infoRouteManager;
        this.threadUtils = threadUtils;
    }

    public class Notice
    extends OperationsNotice {
        Notice() {
            super(OnPremClusterConfigurator.this.toolbox);
        }

        protected void innerHandle() {
            Cluster defaultSpec;
            Cluster diff;
            log.info("Checking for updates");
            DefaultsUpdateType defaultsUpdateType = this.toolbox.getApplicationConfig().getDefaultsUpdateType();
            if (defaultsUpdateType == DefaultsUpdateType.DISABLED) {
                return;
            }
            List clusters = this.toolbox.getClusterDataManager().getAll();
            if (clusters.size() > 1) {
                log.warn("Updating existing cluster via values.yaml file is only supported when there is only one cluster in the system.");
                return;
            }
            if (clusters.isEmpty()) {
                log.info("update defaults configured, but no clusters exist. skipping");
                return;
            }
            Cluster original = (Cluster)clusters.get(0);
            if (!this.allNodesOnline(original)) {
                log.info("no hosts connected or not all hosts online, waiting to update");
                OnPremClusterConfigurator.this.threadUtils.setTimeout(() -> this.toolbox.getNoticeManager().queueNotice((io.imply.cloud.manager.notice.Notice)this, false), 5L, TimeUnit.SECONDS);
                return;
            }
            String shortClusterId = this.toolbox.getClusterDataManager().getVersionOrNull(original.getClusterId(), 0).getMetadataStorage().getSchema();
            ImplyVersion implyVersion = this.toolbox.getDefaultsConfig().getImplyVersionFull();
            if (implyVersion == null) {
                String versionString = this.toolbox.getDefaultsConfig().getImplyVersion();
                if (!Strings.isNullOrEmpty((String)versionString) && (implyVersion = this.toolbox.getRefreshableConstants().lookupImplyVersion(versionString)) == null) {
                    throw new IAE("The Imply version [%s] specified via configuration is not a known version", new Object[]{versionString});
                }
            } else if (!implyVersion.isValid()) {
                throw new IAE("The Imply version specified via configuration does not contain all necessary fields", new Object[0]);
            }
            if ((diff = (defaultSpec = OnPremClusterConfigurator.this.infoRouteManager.getDefaultClusterSpec(original.getClusterId(), shortClusterId).cloner().withoutNonUpdatableFields().withImplyVersionFull(implyVersion).withImplyVersion(implyVersion != null ? implyVersion.getVersion() : null).withSensitiveFieldPlaceholdersReplaced(this.toolbox.getDefaultsConfig()).build()).mergeDiff(original.cloner().withoutNonUpdatableFields().build())).isEmpty()) {
                log.info("update defaults configured, but no changes detected");
                return;
            }
            List possibleUpdateTypes = this.toolbox.getClusterUpdateHelper().getUpdateDetailsForClusterDiff(diff, original).stream().map(UpdateDetails::getType).collect(Collectors.toList());
            UpdateType updateType = UpdateType.NOT_SET;
            if (possibleUpdateTypes.contains(UpdateType.UNSUPPORTED)) {
                log.warn("update defaults configured, but update type is unsupported");
                return;
            }
            if (possibleUpdateTypes.contains(UpdateType.NO_CHANGE)) {
                log.info("update defaults configured, but nothing to update");
                return;
            }
            if (possibleUpdateTypes.contains(UpdateType.ROLLING)) {
                if (defaultsUpdateType == DefaultsUpdateType.ROLLING) {
                    log.info("update defaults configured, apply rolling update");
                    updateType = UpdateType.ROLLING;
                } else if (defaultsUpdateType == DefaultsUpdateType.HARD && !possibleUpdateTypes.contains(UpdateType.HARD)) {
                    log.info("update defaults configured, apply rolling update (hard configured but not available)");
                    updateType = UpdateType.ROLLING;
                } else if (defaultsUpdateType == DefaultsUpdateType.HARD && possibleUpdateTypes.contains(UpdateType.HARD)) {
                    log.info("update defaults configured, apply hard update");
                    updateType = UpdateType.HARD;
                }
            } else if (possibleUpdateTypes.contains(UpdateType.HARD)) {
                if (defaultsUpdateType == DefaultsUpdateType.HARD) {
                    log.info("update defaults configured, apply hard update");
                    updateType = UpdateType.HARD;
                } else {
                    log.warn("Rolling upgrade didn\u2019t proceed as it can only be applied to clusters that are in HA mode. Please check your cluster\u2019s config and rerun or try {Hard Upgrade} Mode");
                    return;
                }
            }
            if (updateType == UpdateType.NOT_SET) {
                log.warn("update defaults configured, no valid update path");
                return;
            }
            Info info = this.toolbox.getEntityStateDataManager().get(original);
            if (!State.CLUSTER_UPDATE_REQUEST_RECEIVED.getValidPreviousStates().contains(info.getState())) {
                log.info("update defaults configured, but in an invalid state [%s]", new Object[]{info.getState()});
                log.error("Attempt of upgrade didn\u2019t proceed as there is one ongoing already.");
                return;
            }
            Cluster merged = original.cloner().withCluster(diff, true).withDefaultsForUnset(this.toolbox.getApplicationConfig(), false, this.toolbox.getInstanceTypeHelper()).build();
            Cluster modifiedParameters = diff.cloner().withoutNonUpdatableFields().withVersion(null).withImplyVersionFull(null).build();
            Cluster originalParameters = original.filterNonNullFields(modifiedParameters);
            Info.Builder updateInfoBuilder = original.getInfoBuilder().withKey(original.key()).withEntityId(original.getClusterId()).withEntityType(EntityType.CLUSTER).withState(State.CLUSTER_UPDATE_REQUEST_RECEIVED).withDesiredState(State.CLUSTER_UPDATED).withUpdateType(updateType).withProposedClusterNodesVersion(Constants.CLEAR_FIELD_INT).withUpdateState(UpdateState.builder().currentState(State.CLUSTER_UPDATE_REQUEST_RECEIVED).modifiedParameters(Cluster.clusterToMapWithoutType((ObjectMapper)this.toolbox.getObjectMapper(), (Cluster)modifiedParameters)).originalParameters(Cluster.clusterToMapWithoutType((ObjectMapper)this.toolbox.getObjectMapper(), (Cluster)originalParameters)).supportedTypes(possibleUpdateTypes).build()).clearExistingUpdateState();
            ClusterWithExtendedInfo updatedClusterWithInfo = this.toolbox.getClusterDataManager().updateWithInfo(merged, updateInfoBuilder.build(), "SYSTEM_DEFAULTS", true, true, false, false, true);
            this.toolbox.getNotificationDataManager().deleteNotificationsWithEntityKey(updatedClusterWithInfo.getCluster().key());
            this.toolbox.getNotificationDataManager().insert(Notification.of((String)"Cluster update triggered", null, (Notification.Level)Notification.Level.INFO, (Notification.Source)Notification.Source.MANAGER, (String)updatedClusterWithInfo.getCluster().key()));
            this.toolbox.getNoticeManager().queueProcessNotice(updatedClusterWithInfo.getExtendedInfo().getInfo());
        }

        private boolean allNodesOnline(Cluster cluster) {
            String groveServer = this.toolbox.getAccountDataManager().get(cluster.getAccountId()).getGroveServer();
            Set hosts = this.toolbox.getClusterNodesDataManager().get(cluster.getClusterId()).getNodes().keySet();
            if (hosts.isEmpty()) {
                return false;
            }
            HashSet offline = new HashSet(hosts);
            this.toolbox.getGroveClient().getGroveNodes(groveServer, true).stream().map(Node::getAddress).forEach(offline::remove);
            return offline.isEmpty();
        }
    }
}

