/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.config;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.imply.cloud.guice.annotations.ManageLifecycleLast;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.FeatureFlag;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Region;
import io.imply.cloud.model.State;
import io.imply.cloud.onprem.config.OnPremManagerConfig;
import io.imply.cloud.onprem.model.OnPremAccount;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.util.Logger;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

@ManageLifecycleLast
public class OnPremAccountConfigurator {
    private static final Logger log = new Logger(OnPremAccountConfigurator.class);
    private final AccountDataManager accountDataManager;
    private final OnPremManagerConfig onPremManagerConfig;

    @Inject
    public OnPremAccountConfigurator(AccountDataManager accountDataManager, OnPremManagerConfig onPremManagerConfig) {
        this.accountDataManager = accountDataManager;
        this.onPremManagerConfig = onPremManagerConfig;
    }

    @LifecycleStart
    public void start() {
        Account existingAccount = this.accountDataManager.getOrNull("onprem");
        if (existingAccount == null) {
            log.info("Creating default on-prem account [%s]", new Object[]{"onprem"});
            Account account = ((OnPremAccount.Builder)((OnPremAccount.Builder)((OnPremAccount.Builder)((OnPremAccount.Builder)((OnPremAccount.Builder)((OnPremAccount.Builder)OnPremAccount.builder().withAccountId("onprem")).withName("Imply OnPrem")).withRegion(Region.NONE)).withTrial(false)).withFeatureFlags((List)ImmutableList.of((Object)"customizeSecurityPolicy"))).withGroveServer(this.onPremManagerConfig.getGroveServer())).build();
            Info info = account.getInfoBuilder().withState(State.ACCOUNT_CREATED).withDesiredState(State.ACCOUNT_CREATED).build();
            this.accountDataManager.createWithInfo(account, info, "SYSTEM");
        } else {
            boolean updated = false;
            Account.Builder accountBuilder = existingAccount.cloner();
            if (!this.onPremManagerConfig.getGroveServer().equals(existingAccount.getGroveServer())) {
                log.info("Updating groveServer configuration from [%s] to [%s] for accountId [%s]", new Object[]{existingAccount.getGroveServer(), this.onPremManagerConfig.getGroveServer(), "onprem"});
                accountBuilder.withGroveServer(this.onPremManagerConfig.getGroveServer());
                updated = true;
            }
            if (!FeatureFlag.enabledForAccount((Account)existingAccount, (String)"customizeSecurityPolicy")) {
                log.info("Updating featureFlags to add [customizeSecurityPolicy] for accountId [%s]", new Object[]{"onprem"});
                ImmutableList featureFlags = ImmutableList.builder().addAll((Iterable)CollectionUtils.emptyIfNull((Collection)existingAccount.getFeatureFlags())).add((Object)"customizeSecurityPolicy").build();
                accountBuilder.withFeatureFlags((List)featureFlags);
                updated = true;
            }
            if (updated) {
                this.accountDataManager.update(accountBuilder.build(), "SYSTEM", true, true);
            }
        }
    }
}

