/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.error;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Objects;
import lombok.Generated;

public enum ErrorCode {
    BAD_ARGUMENT("BadArgument", 400),
    BAD_GATEWAY("BadGateway", 502),
    NOT_FOUND("NotFound", 404),
    SERVER_ERROR("ServerError", 500),
    UNAUTHORIZED("Unauthorized", 401),
    FORBIDDEN("Forbidden", 403),
    STATE_CONFLICT("StateConflict", 409),
    UNSUPPORTED_MEDIA_TYPE("UnsupportedMediaType", 415),
    ALREADY_EXISTS("AlreadyExists"),
    NULL_VALUE("NullValue"),
    MALFORMED_VALUE("MalformedValue"),
    MAX_VALUE_EXCEEDED("MaximumValueExceeded"),
    MIN_VALUE_EXCEEDED("MinimumValueExceeded"),
    INVALID_TYPE("InvalidType"),
    INVALID_URI("InvalidUri");

    private final String value;
    private final Integer status;

    private ErrorCode(String value) {
        this(value, null);
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    public static ErrorCode getByStatusCode(int status) {
        for (ErrorCode errorCode : ErrorCode.values()) {
            if (!Objects.equal((Object)status, (Object)errorCode.status)) continue;
            return errorCode;
        }
        return SERVER_ERROR;
    }

    @Generated
    private ErrorCode(String value, Integer status) {
        this.value = value;
        this.status = status;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }
}

